/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */
'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/searches/Searches' ],
    function (Portal, Backbone, Marionette, $, _) {

    Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _) {
        var singleInstance;

        ListGenerator.Model = Backbone.Model.extend({
            defaults: {
                configTypes: {
                    'wc-list':{name: 'My List', title: 'Wound Care List Generator'}
                },
                title: '',
                searchType: 'wc-list', // if not present, Controller sets to first in list on _configureSearch
                patient: new ListGenerator.Patient()
            },
            searches: new ListGenerator.Searches(),
            //events: {
            //    'change:configTypes': 'validateSearchType' // doesn't like nested objects
            //},
            validate: function (attrs) {
                return undefined;
            },
            validateSearchType: function() {
                var attributes = this.attrs;
                if (typeof attributes.configTypes[attributes.searchType] === "undefined") {
                    attributes.searchType = _.keys(attributes.configTypes)[0];
                }
            }
        });

        ListGenerator.model = (function () {
            if (typeof singleInstance === 'undefined') {
                singleInstance = new ListGenerator.Model();
            }

            return singleInstance;
        })();
    });
});